import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:six_pos/features/splash/controllers/splash_controller.dart';

class PriceConverterHelper {
  static String convertPrice(BuildContext context, double? price, {double? discount, String? discountType, bool isShowLongPrice = false}) {
    if(discount != null){
      if(discountType == 'amount' || discountType == null ) {
        price = price! - discount;
      }else if(discountType == 'percent') {
        price = price! - ((discount / 100) * price);
      }
    }
    return '${Get.find<SplashController>().configModel!.currencySymbol}'  '${isShowLongPrice == true ?
    '${longToShortPrice(price!).replaceAllMapped(RegExp(r'(\d{1,3})(?=(\d{3})+(?!\d))'), (Match m) => '${m[1]},')} '
      : price?.toStringAsFixed(2).replaceAllMapped(RegExp(r'(\d{1,3})(?=(\d{3})+(?!\d))'), (Match m) => '${m[1]},')}';
  }

  static String convertWithDiscount(BuildContext context, double price, double discount, String discountType) {
    if(discountType == 'amount') {
      price = price - discount;
    }else if(discountType == 'percent') {
      price = price - ((discount / 100) * price);
    }
    return '${Get.find<SplashController>().configModel!.currencySymbol}''$price' ;
  }


  static double discountCalculation(BuildContext context,double price, double discount, String? discountType) {
    if(discountType == 'amount') {
      discount =  discount;
    }else if(discountType == 'percent') {
      discount =  ((discount / 100) * price);
    }
    return discount;
  }
  static String discountCalculationWithOutSymbol(BuildContext context,double price, double discount, String? discountType) {
    if(discountType == 'amount') {
      discount =  discount;
    }else if(discountType == 'percent') {
      discount =  ((discount / 100) * price);
    }
    return discount.toStringAsFixed(2);
  }

  static String calculation(double amount, double discount, String type, int quantity) {
    double calculatedAmount = 0;
    if(type == 'amount') {
      calculatedAmount = discount * quantity;
    }else if(type == 'percent') {
      calculatedAmount = (discount / 100) * (amount * quantity);
    }
    return '${Get.find<SplashController>().configModel!.currencySymbol} ${calculatedAmount.toStringAsFixed(2)}';
  }

  static String percentageCalculation(BuildContext context, String price, String discount, String discountType) {
    return '$discount${discountType == 'percent' ? '%' : '${Get.find<SplashController>().configModel!.currencySymbol}'} OFF';
  }

  static String priceWithSymbol(double amount){
    return '${Get.find<SplashController>().configModel!.currencySymbol} ${amount.toStringAsFixed(2)}';
  }

  static String symbolWithPrice(double amount){
    return '${amount.toStringAsFixed(2)} ${Get.find<SplashController>().configModel!.currencySymbol}';
  }

  static String longToShortPrice(double amount, {int decimalPoint = 2}) {

    if (amount.abs() >= 1e12) {
      return '${(amount / 1e12).toStringAsFixed(decimalPoint)}T';
    } else if (amount.abs() >= 1e9) {
      return '${(amount / 1e9).toStringAsFixed(decimalPoint)}B';
    } else if (amount.abs() >= 1e6) {
      return '${(amount / 1e6).toStringAsFixed(decimalPoint)}M';
    } else if (amount.abs() >= 1e3) {
      return '${(amount / 1e3).toStringAsFixed(decimalPoint)}K';
    } else {
      return amount.toStringAsFixed(decimalPoint);
    }
  }

  static String discountWithLogo(BuildContext context, double? discount, String? discountType) {
    return '$discount${discountType == 'percent' ? '%' : '${Get.find<SplashController>().configModel!.currencySymbol}'}';
  }

}